/////////////////////////////////////////////////////////////
// CINEMA SDK : SHADER																		 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4DSHADERDATA_H
#define __C4DSHADERDATA_H

#include "c4d_nodedata.h"

class  PluginShader;
class  BaseObject;
class  BaseDraw;
class  BaseDrawHelp;
class  BaseDocument;
class  BaseBitmap;
class  String;
class  BaseTag;
struct InitRenderStruct;
struct VolumeData;
struct ChannelData;

class ShaderData : public NodeData
{
	public:
		////inherited from NodeData////
		//virtual Bool Init(GeListNode *node);
		//virtual void Free(GeListNode *node);
		//virtual Bool Read(GeListNode *node, HyperFile *hf, LONG level);
		//virtual Bool Write(GeListNode *node, HyperFile *hf);
		//virtual Bool Message(GeListNode *node, LONG type, void *data);
		//virtual Bool CopyTo(NodeData *dest, GeListNode *snode, GeListNode *dnode, LONG flags, AliasTrans *trn);
		//virtual void GetBubbleHelp(GeListNode *node, String &str);
		//virtual BaseDocument* GetDocument(GeListNode *node);
		//virtual LONG GetBranchInfo(GeListNode *node, BranchInfo *info, LONG max);
		//virtual Bool GetDDescription(GeListNode *node, Description *description,LONG &flags);
		//virtual Bool GetDParameter(GeListNode *node, const DescID &id,GeData &t_data,LONG &flags);
		//virtual Bool GetDEnabling(GeListNode *node, const DescID &id,GeData &t_data,LONG flags,const BaseContainer *itemdesc);
		//virtual Bool SetDParameter(GeListNode *node, const DescID &id,const GeData &t_data,LONG &flags);
		//static NodeData *Alloc(void) { return gNew MyNodeData; }
		////inherited from NodeData////

		virtual	Bool Draw(PluginShader *sh, BaseObject *op, BaseTag *tag, BaseDraw *bd, BaseDrawHelp *bh);

		virtual	LONG GetRenderInfo(PluginShader *sh);

		virtual	LONG InitRender(PluginShader *sh, InitRenderStruct *irs);
		virtual	void FreeRender(PluginShader *sh);

		virtual	Vector Output(PluginShader *sh, ChannelData *cd);
};

Bool RegisterShaderPlugin(LONG id, const String &str, LONG info, DataAllocator *g, const String &description, LONG disklevel, void *emulation=NULL);

#endif
